package com.company.model;

import com.company.exceptions.DuplicatedDataException;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SubjectContainer {
    private List<Subject> subjects;
    EnrollContainer enrolls;
    InstructorContainer instructors;
    private Subject search(String initials) {
        Subject  subject;
        Iterator<Subject> it = this.subjects.iterator();
        while(it.hasNext()){
            subject = it.next();
            if(subject.isEqualTo(initials)){
                return subject;
            }
        }
        return null;
    }
    public SubjectContainer(){
        subjects = new ArrayList<Subject>();
    }
    public List<Subject> getAll(){
        List<Subject> newlist = new ArrayList();
        newlist.addAll(this.subjects);
        return newlist;
    }
    public Subject get(String initials){
        Subject subject = search(initials);
        return subject;
    }
    public void add(Subject obj){
        Subject subject = search(obj.getInitials());
        if(subject == null){
            this.subjects.add(obj);
        }else{
            String msg = "Subject: " + obj.getInitials();
            throw  new DuplicatedDataException(msg);
        }
    }
    public void remove(String initials){
        Subject subject = search(initials);
        if(subject != null){
            this.subjects.remove(subject);
        }
    }
    public void update(String initials,String designation){
        Subject subject = search(initials);
        if(subject != null){
            subject.setDesignation(designation);
        }
    }

    public void setEnrolls(EnrollContainer enrolls) {
        this.enrolls = enrolls;
    }

    public void setInstructors(InstructorContainer instructors) {
        this.instructors = instructors;
    }
}
